package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportInstanceTaskDetails(
    description: Option[String] = None,
    instanceId: Option[String] = None,
    platform: Option[zio.aws.ec2.model.PlatformValues] = None,
    volumes: Option[
      Iterable[zio.aws.ec2.model.ImportInstanceVolumeDetailItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportInstanceTaskDetails = {
    import ImportInstanceTaskDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportInstanceTaskDetails
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportInstanceTaskDetails.ReadOnly =
    zio.aws.ec2.model.ImportInstanceTaskDetails.wrap(buildAwsValue())
}
object ImportInstanceTaskDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportInstanceTaskDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportInstanceTaskDetails =
      zio.aws.ec2.model.ImportInstanceTaskDetails(
        description.map(value => value),
        instanceId.map(value => value),
        platform.map(value => value),
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Option[String]
    def instanceId: Option[String]
    def platform: Option[zio.aws.ec2.model.PlatformValues]
    def volumes: Option[
      List[zio.aws.ec2.model.ImportInstanceVolumeDetailItem.ReadOnly]
    ]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getPlatform: ZIO[Any, AwsError, zio.aws.ec2.model.PlatformValues] =
      AwsError.unwrapOptionField("platform", platform)
    def getVolumes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ImportInstanceVolumeDetailItem.ReadOnly
    ]] = AwsError.unwrapOptionField("volumes", volumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportInstanceTaskDetails
  ) extends zio.aws.ec2.model.ImportInstanceTaskDetails.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val platform: Option[zio.aws.ec2.model.PlatformValues] = scala
      .Option(impl.platform())
      .map(value => zio.aws.ec2.model.PlatformValues.wrap(value))
    override val volumes: Option[
      List[zio.aws.ec2.model.ImportInstanceVolumeDetailItem.ReadOnly]
    ] = scala
      .Option(impl.volumes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ImportInstanceVolumeDetailItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportInstanceTaskDetails
  ): zio.aws.ec2.model.ImportInstanceTaskDetails.ReadOnly = new Wrapper(impl)
}
