package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayRouteTableId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExportTransitGatewayRoutesRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    s3Bucket: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesRequest = {
    import ExportTransitGatewayRoutesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .s3Bucket(s3Bucket: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ExportTransitGatewayRoutesRequest.ReadOnly =
    zio.aws.ec2.model.ExportTransitGatewayRoutesRequest.wrap(buildAwsValue())
}
object ExportTransitGatewayRoutesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ExportTransitGatewayRoutesRequest =
      zio.aws.ec2.model.ExportTransitGatewayRoutesRequest(
        transitGatewayRouteTableId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        s3Bucket
      )
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def s3Bucket: String
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getS3Bucket: ZIO[Any, Nothing, String] = ZIO.succeed(s3Bucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesRequest
  ) extends zio.aws.ec2.model.ExportTransitGatewayRoutesRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val s3Bucket: String = impl.s3Bucket(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportTransitGatewayRoutesRequest
  ): zio.aws.ec2.model.ExportTransitGatewayRoutesRequest.ReadOnly = new Wrapper(
    impl
  )
}
