package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VolumeId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableVolumeIoRequest(volumeId: VolumeId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest = {
    import EnableVolumeIoRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest
      .builder()
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnableVolumeIoRequest.ReadOnly =
    zio.aws.ec2.model.EnableVolumeIoRequest.wrap(buildAwsValue())
}
object EnableVolumeIoRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableVolumeIoRequest =
      zio.aws.ec2.model.EnableVolumeIoRequest(volumeId)
    def volumeId: VolumeId
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest
  ) extends zio.aws.ec2.model.EnableVolumeIoRequest.ReadOnly {
    override val volumeId: VolumeId =
      zio.aws.ec2.model.primitives.VolumeId(impl.volumeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest
  ): zio.aws.ec2.model.EnableVolumeIoRequest.ReadOnly = new Wrapper(impl)
}
