package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnableFastSnapshotRestoreStateErrorItem(
    availabilityZone: Option[String] = None,
    error: Option[zio.aws.ec2.model.EnableFastSnapshotRestoreStateError] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreStateErrorItem = {
    import EnableFastSnapshotRestoreStateErrorItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreStateErrorItem
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.EnableFastSnapshotRestoreStateErrorItem.ReadOnly =
    zio.aws.ec2.model.EnableFastSnapshotRestoreStateErrorItem
      .wrap(buildAwsValue())
}
object EnableFastSnapshotRestoreStateErrorItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreStateErrorItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableFastSnapshotRestoreStateErrorItem =
      zio.aws.ec2.model.EnableFastSnapshotRestoreStateErrorItem(
        availabilityZone.map(value => value),
        error.map(value => value.asEditable)
      )
    def availabilityZone: Option[String]
    def error
        : Option[zio.aws.ec2.model.EnableFastSnapshotRestoreStateError.ReadOnly]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.EnableFastSnapshotRestoreStateError.ReadOnly
    ] = AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreStateErrorItem
  ) extends zio.aws.ec2.model.EnableFastSnapshotRestoreStateErrorItem.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val error: Option[
      zio.aws.ec2.model.EnableFastSnapshotRestoreStateError.ReadOnly
    ] = scala
      .Option(impl.error())
      .map(value =>
        zio.aws.ec2.model.EnableFastSnapshotRestoreStateError.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoreStateErrorItem
  ): zio.aws.ec2.model.EnableFastSnapshotRestoreStateErrorItem.ReadOnly =
    new Wrapper(impl)
}
