package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateInstanceEventWindowResponse(
    instanceEventWindow: Option[zio.aws.ec2.model.InstanceEventWindow] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowResponse = {
    import DisassociateInstanceEventWindowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowResponse
      .builder()
      .optionallyWith(instanceEventWindow.map(value => value.buildAwsValue()))(
        _.instanceEventWindow
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateInstanceEventWindowResponse.ReadOnly =
    zio.aws.ec2.model.DisassociateInstanceEventWindowResponse
      .wrap(buildAwsValue())
}
object DisassociateInstanceEventWindowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateInstanceEventWindowResponse =
      zio.aws.ec2.model.DisassociateInstanceEventWindowResponse(
        instanceEventWindow.map(value => value.asEditable)
      )
    def instanceEventWindow
        : Option[zio.aws.ec2.model.InstanceEventWindow.ReadOnly]
    def getInstanceEventWindow
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceEventWindow.ReadOnly] =
      AwsError.unwrapOptionField("instanceEventWindow", instanceEventWindow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowResponse
  ) extends zio.aws.ec2.model.DisassociateInstanceEventWindowResponse.ReadOnly {
    override val instanceEventWindow
        : Option[zio.aws.ec2.model.InstanceEventWindow.ReadOnly] = scala
      .Option(impl.instanceEventWindow())
      .map(value => zio.aws.ec2.model.InstanceEventWindow.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateInstanceEventWindowResponse
  ): zio.aws.ec2.model.DisassociateInstanceEventWindowResponse.ReadOnly =
    new Wrapper(impl)
}
