package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, VolumeId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVolumesModificationsRequest(
    volumeIds: Option[Iterable[VolumeId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest = {
    import DescribeVolumesModificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest
      .builder()
      .optionallyWith(
        volumeIds.map(value =>
          value.map { item =>
            VolumeId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.volumeIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVolumesModificationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVolumesModificationsRequest.wrap(buildAwsValue())
}
object DescribeVolumesModificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVolumesModificationsRequest =
      zio.aws.ec2.model.DescribeVolumesModificationsRequest(
        volumeIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def volumeIds: Option[List[VolumeId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def nextToken: Option[String]
    def maxResults: Option[Integer]
    def getVolumeIds: ZIO[Any, AwsError, List[VolumeId]] =
      AwsError.unwrapOptionField("volumeIds", volumeIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest
  ) extends zio.aws.ec2.model.DescribeVolumesModificationsRequest.ReadOnly {
    override val volumeIds: Option[List[VolumeId]] = scala
      .Option(impl.volumeIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VolumeId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest
  ): zio.aws.ec2.model.DescribeVolumesModificationsRequest.ReadOnly =
    new Wrapper(impl)
}
