package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStaleSecurityGroupsResponse(
    nextToken: Option[String] = None,
    staleSecurityGroupSet: Option[
      Iterable[zio.aws.ec2.model.StaleSecurityGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsResponse = {
    import DescribeStaleSecurityGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        staleSecurityGroupSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.staleSecurityGroupSet)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeStaleSecurityGroupsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeStaleSecurityGroupsResponse.wrap(buildAwsValue())
}
object DescribeStaleSecurityGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeStaleSecurityGroupsResponse =
      zio.aws.ec2.model.DescribeStaleSecurityGroupsResponse(
        nextToken.map(value => value),
        staleSecurityGroupSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[String]
    def staleSecurityGroupSet
        : Option[List[zio.aws.ec2.model.StaleSecurityGroup.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStaleSecurityGroupSet: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.StaleSecurityGroup.ReadOnly
    ]] =
      AwsError.unwrapOptionField("staleSecurityGroupSet", staleSecurityGroupSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsResponse
  ) extends zio.aws.ec2.model.DescribeStaleSecurityGroupsResponse.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val staleSecurityGroupSet
        : Option[List[zio.aws.ec2.model.StaleSecurityGroup.ReadOnly]] = scala
      .Option(impl.staleSecurityGroupSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.StaleSecurityGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsResponse
  ): zio.aws.ec2.model.DescribeStaleSecurityGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
