package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SnapshotId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotsRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None,
    ownerIds: Option[Iterable[String]] = None,
    restorableByUserIds: Option[Iterable[String]] = None,
    snapshotIds: Option[Iterable[SnapshotId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest = {
    import DescribeSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        ownerIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ownerIds)
      .optionallyWith(
        restorableByUserIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.restorableByUserIds)
      .optionallyWith(
        snapshotIds.map(value =>
          value.map { item =>
            SnapshotId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.snapshotIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSnapshotsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSnapshotsRequest.wrap(buildAwsValue())
}
object DescribeSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSnapshotsRequest =
      zio.aws.ec2.model.DescribeSnapshotsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        ownerIds.map(value => value),
        restorableByUserIds.map(value => value),
        snapshotIds.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def ownerIds: Option[List[String]]
    def restorableByUserIds: Option[List[String]]
    def snapshotIds: Option[List[SnapshotId]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOwnerIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ownerIds", ownerIds)
    def getRestorableByUserIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("restorableByUserIds", restorableByUserIds)
    def getSnapshotIds: ZIO[Any, AwsError, List[SnapshotId]] =
      AwsError.unwrapOptionField("snapshotIds", snapshotIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest
  ) extends zio.aws.ec2.model.DescribeSnapshotsRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val ownerIds: Option[List[String]] = scala
      .Option(impl.ownerIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val restorableByUserIds: Option[List[String]] = scala
      .Option(impl.restorableByUserIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val snapshotIds: Option[List[SnapshotId]] = scala
      .Option(impl.snapshotIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SnapshotId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest
  ): zio.aws.ec2.model.DescribeSnapshotsRequest.ReadOnly = new Wrapper(impl)
}
