package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReplaceRootVolumeTasksResponse(
    replaceRootVolumeTasks: Option[
      Iterable[zio.aws.ec2.model.ReplaceRootVolumeTask]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksResponse = {
    import DescribeReplaceRootVolumeTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksResponse
      .builder()
      .optionallyWith(
        replaceRootVolumeTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replaceRootVolumeTasks)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeReplaceRootVolumeTasksResponse.ReadOnly =
    zio.aws.ec2.model.DescribeReplaceRootVolumeTasksResponse
      .wrap(buildAwsValue())
}
object DescribeReplaceRootVolumeTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeReplaceRootVolumeTasksResponse =
      zio.aws.ec2.model.DescribeReplaceRootVolumeTasksResponse(
        replaceRootVolumeTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def replaceRootVolumeTasks
        : Option[List[zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly]]
    def nextToken: Option[String]
    def getReplaceRootVolumeTasks: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "replaceRootVolumeTasks",
      replaceRootVolumeTasks
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksResponse
  ) extends zio.aws.ec2.model.DescribeReplaceRootVolumeTasksResponse.ReadOnly {
    override val replaceRootVolumeTasks
        : Option[List[zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly]] = scala
      .Option(impl.replaceRootVolumeTasks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ReplaceRootVolumeTask.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReplaceRootVolumeTasksResponse
  ): zio.aws.ec2.model.DescribeReplaceRootVolumeTasksResponse.ReadOnly =
    new Wrapper(impl)
}
