package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInterfaceAttributeResponse(
    attachment: Option[zio.aws.ec2.model.NetworkInterfaceAttachment] = None,
    description: Option[zio.aws.ec2.model.AttributeValue] = None,
    groups: Option[Iterable[zio.aws.ec2.model.GroupIdentifier]] = None,
    networkInterfaceId: Option[String] = None,
    sourceDestCheck: Option[zio.aws.ec2.model.AttributeBooleanValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse = {
    import DescribeNetworkInterfaceAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(description.map(value => value.buildAwsValue()))(
        _.description
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(sourceDestCheck.map(value => value.buildAwsValue()))(
        _.sourceDestCheck
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse
      .wrap(buildAwsValue())
}
object DescribeNetworkInterfaceAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse =
      zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse(
        attachment.map(value => value.asEditable),
        description.map(value => value.asEditable),
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkInterfaceId.map(value => value),
        sourceDestCheck.map(value => value.asEditable)
      )
    def attachment
        : Option[zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly]
    def description: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def groups: Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def networkInterfaceId: Option[String]
    def sourceDestCheck
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def getAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly
    ] = AwsError.unwrapOptionField("attachment", attachment)
    def getDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("description", description)
    def getGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("groups", groups)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getSourceDestCheck
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse
  ) extends zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse.ReadOnly {
    override val attachment
        : Option[zio.aws.ec2.model.NetworkInterfaceAttachment.ReadOnly] = scala
      .Option(impl.attachment())
      .map(value => zio.aws.ec2.model.NetworkInterfaceAttachment.wrap(value))
    override val description
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly] = scala
      .Option(impl.description())
      .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val groups
        : Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.GroupIdentifier.wrap(item)
        }.toList
      )
    override val networkInterfaceId: Option[String] =
      scala.Option(impl.networkInterfaceId()).map(value => value: String)
    override val sourceDestCheck
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.sourceDestCheck())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeResponse
  ): zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse.ReadOnly =
    new Wrapper(impl)
}
