package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstanceEventWindowsResponse(
    instanceEventWindows: Option[
      Iterable[zio.aws.ec2.model.InstanceEventWindow]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsResponse = {
    import DescribeInstanceEventWindowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsResponse
      .builder()
      .optionallyWith(
        instanceEventWindows.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceEventWindows)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeInstanceEventWindowsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceEventWindowsResponse.wrap(buildAwsValue())
}
object DescribeInstanceEventWindowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceEventWindowsResponse =
      zio.aws.ec2.model.DescribeInstanceEventWindowsResponse(
        instanceEventWindows.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceEventWindows
        : Option[List[zio.aws.ec2.model.InstanceEventWindow.ReadOnly]]
    def nextToken: Option[String]
    def getInstanceEventWindows: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceEventWindow.ReadOnly
    ]] =
      AwsError.unwrapOptionField("instanceEventWindows", instanceEventWindows)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsResponse
  ) extends zio.aws.ec2.model.DescribeInstanceEventWindowsResponse.ReadOnly {
    override val instanceEventWindows
        : Option[List[zio.aws.ec2.model.InstanceEventWindow.ReadOnly]] = scala
      .Option(impl.instanceEventWindows())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceEventWindow.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsResponse
  ): zio.aws.ec2.model.DescribeInstanceEventWindowsResponse.ReadOnly =
    new Wrapper(impl)
}
