package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{FleetId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeFleetInstancesRequest(
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None,
    fleetId: FleetId,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesRequest = {
    import DescribeFleetInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFleetInstancesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeFleetInstancesRequest.wrap(buildAwsValue())
}
object DescribeFleetInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFleetInstancesRequest =
      zio.aws.ec2.model.DescribeFleetInstancesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        fleetId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def fleetId: FleetId
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesRequest
  ) extends zio.aws.ec2.model.DescribeFleetInstancesRequest.ReadOnly {
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val fleetId: FleetId =
      zio.aws.ec2.model.primitives.FleetId(impl.fleetId())
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesRequest
  ): zio.aws.ec2.model.DescribeFleetInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
