package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{DateTime, FleetId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeFleetHistoryRequest(
    eventType: Option[zio.aws.ec2.model.FleetEventType] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None,
    fleetId: FleetId,
    startTime: DateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest = {
    import DescribeFleetHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest
      .builder()
      .optionallyWith(eventType.map(value => value.unwrap))(_.eventType)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .startTime(DateTime.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFleetHistoryRequest.ReadOnly =
    zio.aws.ec2.model.DescribeFleetHistoryRequest.wrap(buildAwsValue())
}
object DescribeFleetHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFleetHistoryRequest =
      zio.aws.ec2.model.DescribeFleetHistoryRequest(
        eventType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        fleetId,
        startTime
      )
    def eventType: Option[zio.aws.ec2.model.FleetEventType]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def fleetId: FleetId
    def startTime: DateTime
    def getEventType: ZIO[Any, AwsError, zio.aws.ec2.model.FleetEventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getStartTime: ZIO[Any, Nothing, DateTime] = ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest
  ) extends zio.aws.ec2.model.DescribeFleetHistoryRequest.ReadOnly {
    override val eventType: Option[zio.aws.ec2.model.FleetEventType] = scala
      .Option(impl.eventType())
      .map(value => zio.aws.ec2.model.FleetEventType.wrap(value))
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val fleetId: FleetId =
      zio.aws.ec2.model.primitives.FleetId(impl.fleetId())
    override val startTime: DateTime =
      zio.aws.ec2.model.primitives.DateTime(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest
  ): zio.aws.ec2.model.DescribeFleetHistoryRequest.ReadOnly = new Wrapper(impl)
}
