package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeDhcpOptionsResponse(
    dhcpOptions: Option[Iterable[zio.aws.ec2.model.DhcpOptions]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse = {
    import DescribeDhcpOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse
      .builder()
      .optionallyWith(
        dhcpOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dhcpOptions)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeDhcpOptionsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeDhcpOptionsResponse.wrap(buildAwsValue())
}
object DescribeDhcpOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeDhcpOptionsResponse =
      zio.aws.ec2.model.DescribeDhcpOptionsResponse(
        dhcpOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dhcpOptions: Option[List[zio.aws.ec2.model.DhcpOptions.ReadOnly]]
    def nextToken: Option[String]
    def getDhcpOptions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.DhcpOptions.ReadOnly]] =
      AwsError.unwrapOptionField("dhcpOptions", dhcpOptions)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse
  ) extends zio.aws.ec2.model.DescribeDhcpOptionsResponse.ReadOnly {
    override val dhcpOptions
        : Option[List[zio.aws.ec2.model.DhcpOptions.ReadOnly]] = scala
      .Option(impl.dhcpOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.DhcpOptions.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsResponse
  ): zio.aws.ec2.model.DescribeDhcpOptionsResponse.ReadOnly = new Wrapper(impl)
}
