package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeClientVpnTargetNetworksMaxResults,
  ClientVpnEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeClientVpnTargetNetworksRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    associationIds: Option[Iterable[String]] = None,
    maxResults: Option[DescribeClientVpnTargetNetworksMaxResults] = None,
    nextToken: Option[NextToken] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest = {
    import DescribeClientVpnTargetNetworksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .optionallyWith(
        associationIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.associationIds)
      .optionallyWith(
        maxResults.map(value =>
          DescribeClientVpnTargetNetworksMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest.ReadOnly =
    zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest
      .wrap(buildAwsValue())
}
object DescribeClientVpnTargetNetworksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest =
      zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest(
        clientVpnEndpointId,
        associationIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def associationIds: Option[List[String]]
    def maxResults: Option[DescribeClientVpnTargetNetworksMaxResults]
    def nextToken: Option[NextToken]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getAssociationIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("associationIds", associationIds)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeClientVpnTargetNetworksMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest
  ) extends zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val associationIds: Option[List[String]] = scala
      .Option(impl.associationIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maxResults: Option[DescribeClientVpnTargetNetworksMaxResults] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeClientVpnTargetNetworksMaxResults(value)
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest
  ): zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest.ReadOnly =
    new Wrapper(impl)
}
