package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{AddressMaxResults, NextToken, AllocationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAddressesAttributeRequest(
    allocationIds: Option[Iterable[AllocationId]] = None,
    attribute: Option[zio.aws.ec2.model.AddressAttributeName] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[AddressMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest = {
    import DescribeAddressesAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest
      .builder()
      .optionallyWith(
        allocationIds.map(value =>
          value.map { item =>
            AllocationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allocationIds)
      .optionallyWith(attribute.map(value => value.unwrap))(_.attribute)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => AddressMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeAddressesAttributeRequest.ReadOnly =
    zio.aws.ec2.model.DescribeAddressesAttributeRequest.wrap(buildAwsValue())
}
object DescribeAddressesAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAddressesAttributeRequest =
      zio.aws.ec2.model.DescribeAddressesAttributeRequest(
        allocationIds.map(value => value),
        attribute.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def allocationIds: Option[List[AllocationId]]
    def attribute: Option[zio.aws.ec2.model.AddressAttributeName]
    def nextToken: Option[NextToken]
    def maxResults: Option[AddressMaxResults]
    def getAllocationIds: ZIO[Any, AwsError, List[AllocationId]] =
      AwsError.unwrapOptionField("allocationIds", allocationIds)
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.ec2.model.AddressAttributeName] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, AddressMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest
  ) extends zio.aws.ec2.model.DescribeAddressesAttributeRequest.ReadOnly {
    override val allocationIds: Option[List[AllocationId]] = scala
      .Option(impl.allocationIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.AllocationId(item)
        }.toList
      )
    override val attribute: Option[zio.aws.ec2.model.AddressAttributeName] =
      scala
        .Option(impl.attribute())
        .map(value => zio.aws.ec2.model.AddressAttributeName.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val maxResults: Option[AddressMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.AddressMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressesAttributeRequest
  ): zio.aws.ec2.model.DescribeAddressesAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
