package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteFpgaImageResponse(returnValue: Option[Boolean] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteFpgaImageResponse = {
    import DeleteFpgaImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteFpgaImageResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteFpgaImageResponse.ReadOnly =
    zio.aws.ec2.model.DeleteFpgaImageResponse.wrap(buildAwsValue())
}
object DeleteFpgaImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteFpgaImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteFpgaImageResponse =
      zio.aws.ec2.model.DeleteFpgaImageResponse(returnValue.map(value => value))
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFpgaImageResponse
  ) extends zio.aws.ec2.model.DeleteFpgaImageResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFpgaImageResponse
  ): zio.aws.ec2.model.DeleteFpgaImageResponse.ReadOnly = new Wrapper(impl)
}
