package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CustomerGateway(
    bgpAsn: Option[String] = None,
    customerGatewayId: Option[String] = None,
    ipAddress: Option[String] = None,
    certificateArn: Option[String] = None,
    state: Option[String] = None,
    `type`: Option[String] = None,
    deviceName: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CustomerGateway = {
    import CustomerGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CustomerGateway
      .builder()
      .optionallyWith(bgpAsn.map(value => value: java.lang.String))(_.bgpAsn)
      .optionallyWith(customerGatewayId.map(value => value: java.lang.String))(
        _.customerGatewayId
      )
      .optionallyWith(ipAddress.map(value => value: java.lang.String))(
        _.ipAddress
      )
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(deviceName.map(value => value: java.lang.String))(
        _.deviceName
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CustomerGateway.ReadOnly =
    zio.aws.ec2.model.CustomerGateway.wrap(buildAwsValue())
}
object CustomerGateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CustomerGateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CustomerGateway =
      zio.aws.ec2.model.CustomerGateway(
        bgpAsn.map(value => value),
        customerGatewayId.map(value => value),
        ipAddress.map(value => value),
        certificateArn.map(value => value),
        state.map(value => value),
        `type`.map(value => value),
        deviceName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def bgpAsn: Option[String]
    def customerGatewayId: Option[String]
    def ipAddress: Option[String]
    def certificateArn: Option[String]
    def state: Option[String]
    def `type`: Option[String]
    def deviceName: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getBgpAsn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bgpAsn", bgpAsn)
    def getCustomerGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerGatewayId", customerGatewayId)
    def getIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CustomerGateway
  ) extends zio.aws.ec2.model.CustomerGateway.ReadOnly {
    override val bgpAsn: Option[String] =
      scala.Option(impl.bgpAsn()).map(value => value: String)
    override val customerGatewayId: Option[String] =
      scala.Option(impl.customerGatewayId()).map(value => value: String)
    override val ipAddress: Option[String] =
      scala.Option(impl.ipAddress()).map(value => value: String)
    override val certificateArn: Option[String] =
      scala.Option(impl.certificateArn()).map(value => value: String)
    override val state: Option[String] =
      scala.Option(impl.state()).map(value => value: String)
    override val `type`: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
    override val deviceName: Option[String] =
      scala.Option(impl.deviceName()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CustomerGateway
  ): zio.aws.ec2.model.CustomerGateway.ReadOnly = new Wrapper(impl)
}
