package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateIpamRequest(
    description: Option[String] = None,
    operatingRegions: Option[
      Iterable[zio.aws.ec2.model.AddIpamOperatingRegion]
    ] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateIpamRequest = {
    import CreateIpamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateIpamRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        operatingRegions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operatingRegions)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateIpamRequest.ReadOnly =
    zio.aws.ec2.model.CreateIpamRequest.wrap(buildAwsValue())
}
object CreateIpamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateIpamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateIpamRequest =
      zio.aws.ec2.model.CreateIpamRequest(
        description.map(value => value),
        operatingRegions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def description: Option[String]
    def operatingRegions
        : Option[List[zio.aws.ec2.model.AddIpamOperatingRegion.ReadOnly]]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: Option[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getOperatingRegions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AddIpamOperatingRegion.ReadOnly
    ]] = AwsError.unwrapOptionField("operatingRegions", operatingRegions)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamRequest
  ) extends zio.aws.ec2.model.CreateIpamRequest.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val operatingRegions
        : Option[List[zio.aws.ec2.model.AddIpamOperatingRegion.ReadOnly]] =
      scala
        .Option(impl.operatingRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AddIpamOperatingRegion.wrap(item)
          }.toList
        )
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamRequest
  ): zio.aws.ec2.model.CreateIpamRequest.ReadOnly = new Wrapper(impl)
}
