package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelSpotFleetRequestsError(
    code: Option[zio.aws.ec2.model.CancelBatchErrorCode] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsError = {
    import CancelSpotFleetRequestsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsError
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelSpotFleetRequestsError.ReadOnly =
    zio.aws.ec2.model.CancelSpotFleetRequestsError.wrap(buildAwsValue())
}
object CancelSpotFleetRequestsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelSpotFleetRequestsError =
      zio.aws.ec2.model.CancelSpotFleetRequestsError(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Option[zio.aws.ec2.model.CancelBatchErrorCode]
    def message: Option[String]
    def getCode: ZIO[Any, AwsError, zio.aws.ec2.model.CancelBatchErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsError
  ) extends zio.aws.ec2.model.CancelSpotFleetRequestsError.ReadOnly {
    override val code: Option[zio.aws.ec2.model.CancelBatchErrorCode] = scala
      .Option(impl.code())
      .map(value => zio.aws.ec2.model.CancelBatchErrorCode.wrap(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsError
  ): zio.aws.ec2.model.CancelSpotFleetRequestsError.ReadOnly = new Wrapper(impl)
}
