package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateInstanceEventWindowResponse(
    instanceEventWindow: Option[zio.aws.ec2.model.InstanceEventWindow] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowResponse = {
    import AssociateInstanceEventWindowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowResponse
      .builder()
      .optionallyWith(instanceEventWindow.map(value => value.buildAwsValue()))(
        _.instanceEventWindow
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateInstanceEventWindowResponse.ReadOnly =
    zio.aws.ec2.model.AssociateInstanceEventWindowResponse.wrap(buildAwsValue())
}
object AssociateInstanceEventWindowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateInstanceEventWindowResponse =
      zio.aws.ec2.model.AssociateInstanceEventWindowResponse(
        instanceEventWindow.map(value => value.asEditable)
      )
    def instanceEventWindow
        : Option[zio.aws.ec2.model.InstanceEventWindow.ReadOnly]
    def getInstanceEventWindow
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceEventWindow.ReadOnly] =
      AwsError.unwrapOptionField("instanceEventWindow", instanceEventWindow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowResponse
  ) extends zio.aws.ec2.model.AssociateInstanceEventWindowResponse.ReadOnly {
    override val instanceEventWindow
        : Option[zio.aws.ec2.model.InstanceEventWindow.ReadOnly] = scala
      .Option(impl.instanceEventWindow())
      .map(value => zio.aws.ec2.model.InstanceEventWindow.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateInstanceEventWindowResponse
  ): zio.aws.ec2.model.AssociateInstanceEventWindowResponse.ReadOnly =
    new Wrapper(impl)
}
