package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SubnetId, ClientVpnEndpointId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateClientVpnTargetNetworkRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    subnetId: SubnetId,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest = {
    import AssociateClientVpnTargetNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest.ReadOnly =
    zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest
      .wrap(buildAwsValue())
}
object AssociateClientVpnTargetNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest =
      zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest(
        clientVpnEndpointId,
        subnetId,
        clientToken.map(value => value)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def subnetId: SubnetId
    def clientToken: Option[String]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest
  ) extends zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val subnetId: SubnetId =
      zio.aws.ec2.model.primitives.SubnetId(impl.subnetId())
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateClientVpnTargetNetworkRequest
  ): zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
