package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AcceptReservedInstancesExchangeQuoteResponse(
    exchangeId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteResponse = {
    import AcceptReservedInstancesExchangeQuoteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteResponse
      .builder()
      .optionallyWith(exchangeId.map(value => value: java.lang.String))(
        _.exchangeId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteResponse.ReadOnly =
    zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteResponse
      .wrap(buildAwsValue())
}
object AcceptReservedInstancesExchangeQuoteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteResponse =
      zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteResponse(
        exchangeId.map(value => value)
      )
    def exchangeId: Option[String]
    def getExchangeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("exchangeId", exchangeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteResponse
  ) extends zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteResponse.ReadOnly {
    override val exchangeId: Option[String] =
      scala.Option(impl.exchangeId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptReservedInstancesExchangeQuoteResponse
  ): zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteResponse.ReadOnly =
    new Wrapper(impl)
}
