package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpcPeeringConnectionStateReason(
    code: Option[zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReason = {
    import VpcPeeringConnectionStateReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReason
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpcPeeringConnectionStateReason.ReadOnly =
    zio.aws.ec2.model.VpcPeeringConnectionStateReason.wrap(buildAwsValue())
}
object VpcPeeringConnectionStateReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpcPeeringConnectionStateReason =
      zio.aws.ec2.model.VpcPeeringConnectionStateReason(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Option[zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode]
    def message: Option[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReason
  ) extends zio.aws.ec2.model.VpcPeeringConnectionStateReason.ReadOnly {
    override val code
        : Option[zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode] = scala
      .Option(impl.code())
      .map(value =>
        zio.aws.ec2.model.VpcPeeringConnectionStateReasonCode.wrap(value)
      )
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionStateReason
  ): zio.aws.ec2.model.VpcPeeringConnectionStateReason.ReadOnly = new Wrapper(
    impl
  )
}
