package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpcCidrBlockAssociation(
    associationId: Option[String] = None,
    cidrBlock: Option[String] = None,
    cidrBlockState: Option[zio.aws.ec2.model.VpcCidrBlockState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation = {
    import VpcCidrBlockAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation
      .builder()
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .optionallyWith(cidrBlockState.map(value => value.buildAwsValue()))(
        _.cidrBlockState
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly =
    zio.aws.ec2.model.VpcCidrBlockAssociation.wrap(buildAwsValue())
}
object VpcCidrBlockAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpcCidrBlockAssociation =
      zio.aws.ec2.model.VpcCidrBlockAssociation(
        associationId.map(value => value),
        cidrBlock.map(value => value),
        cidrBlockState.map(value => value.asEditable)
      )
    def associationId: Option[String]
    def cidrBlock: Option[String]
    def cidrBlockState: Option[zio.aws.ec2.model.VpcCidrBlockState.ReadOnly]
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getCidrBlockState
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpcCidrBlockState.ReadOnly] =
      AwsError.unwrapOptionField("cidrBlockState", cidrBlockState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation
  ) extends zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly {
    override val associationId: Option[String] =
      scala.Option(impl.associationId()).map(value => value: String)
    override val cidrBlock: Option[String] =
      scala.Option(impl.cidrBlock()).map(value => value: String)
    override val cidrBlockState
        : Option[zio.aws.ec2.model.VpcCidrBlockState.ReadOnly] = scala
      .Option(impl.cidrBlockState())
      .map(value => zio.aws.ec2.model.VpcCidrBlockState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation
  ): zio.aws.ec2.model.VpcCidrBlockAssociation.ReadOnly = new Wrapper(impl)
}
