package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VolumeStatusItem(
    actions: Option[Iterable[zio.aws.ec2.model.VolumeStatusAction]] = None,
    availabilityZone: Option[String] = None,
    outpostArn: Option[String] = None,
    events: Option[Iterable[zio.aws.ec2.model.VolumeStatusEvent]] = None,
    volumeId: Option[String] = None,
    volumeStatus: Option[zio.aws.ec2.model.VolumeStatusInfo] = None,
    attachmentStatuses: Option[
      Iterable[zio.aws.ec2.model.VolumeStatusAttachmentStatus]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VolumeStatusItem = {
    import VolumeStatusItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VolumeStatusItem
      .builder()
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actions)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .optionallyWith(volumeStatus.map(value => value.buildAwsValue()))(
        _.volumeStatus
      )
      .optionallyWith(
        attachmentStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachmentStatuses)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VolumeStatusItem.ReadOnly =
    zio.aws.ec2.model.VolumeStatusItem.wrap(buildAwsValue())
}
object VolumeStatusItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VolumeStatusItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VolumeStatusItem =
      zio.aws.ec2.model.VolumeStatusItem(
        actions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZone.map(value => value),
        outpostArn.map(value => value),
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        volumeId.map(value => value),
        volumeStatus.map(value => value.asEditable),
        attachmentStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def actions: Option[List[zio.aws.ec2.model.VolumeStatusAction.ReadOnly]]
    def availabilityZone: Option[String]
    def outpostArn: Option[String]
    def events: Option[List[zio.aws.ec2.model.VolumeStatusEvent.ReadOnly]]
    def volumeId: Option[String]
    def volumeStatus: Option[zio.aws.ec2.model.VolumeStatusInfo.ReadOnly]
    def attachmentStatuses
        : Option[List[zio.aws.ec2.model.VolumeStatusAttachmentStatus.ReadOnly]]
    def getActions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VolumeStatusAction.ReadOnly
    ]] = AwsError.unwrapOptionField("actions", actions)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getEvents: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VolumeStatusEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getVolumeStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.VolumeStatusInfo.ReadOnly] =
      AwsError.unwrapOptionField("volumeStatus", volumeStatus)
    def getAttachmentStatuses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VolumeStatusAttachmentStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("attachmentStatuses", attachmentStatuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusItem
  ) extends zio.aws.ec2.model.VolumeStatusItem.ReadOnly {
    override val actions
        : Option[List[zio.aws.ec2.model.VolumeStatusAction.ReadOnly]] = scala
      .Option(impl.actions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VolumeStatusAction.wrap(item)
        }.toList
      )
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val outpostArn: Option[String] =
      scala.Option(impl.outpostArn()).map(value => value: String)
    override val events
        : Option[List[zio.aws.ec2.model.VolumeStatusEvent.ReadOnly]] = scala
      .Option(impl.events())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VolumeStatusEvent.wrap(item)
        }.toList
      )
    override val volumeId: Option[String] =
      scala.Option(impl.volumeId()).map(value => value: String)
    override val volumeStatus
        : Option[zio.aws.ec2.model.VolumeStatusInfo.ReadOnly] = scala
      .Option(impl.volumeStatus())
      .map(value => zio.aws.ec2.model.VolumeStatusInfo.wrap(value))
    override val attachmentStatuses: Option[
      List[zio.aws.ec2.model.VolumeStatusAttachmentStatus.ReadOnly]
    ] = scala
      .Option(impl.attachmentStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VolumeStatusAttachmentStatus.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusItem
  ): zio.aws.ec2.model.VolumeStatusItem.ReadOnly = new Wrapper(impl)
}
