package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.MillisecondDateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class VolumeStatusEvent(
    description: Option[String] = None,
    eventId: Option[String] = None,
    eventType: Option[String] = None,
    notAfter: Option[MillisecondDateTime] = None,
    notBefore: Option[MillisecondDateTime] = None,
    instanceId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VolumeStatusEvent = {
    import VolumeStatusEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VolumeStatusEvent
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(eventId.map(value => value: java.lang.String))(_.eventId)
      .optionallyWith(eventType.map(value => value: java.lang.String))(
        _.eventType
      )
      .optionallyWith(
        notAfter.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.notAfter)
      .optionallyWith(
        notBefore.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.notBefore)
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VolumeStatusEvent.ReadOnly =
    zio.aws.ec2.model.VolumeStatusEvent.wrap(buildAwsValue())
}
object VolumeStatusEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VolumeStatusEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VolumeStatusEvent =
      zio.aws.ec2.model.VolumeStatusEvent(
        description.map(value => value),
        eventId.map(value => value),
        eventType.map(value => value),
        notAfter.map(value => value),
        notBefore.map(value => value),
        instanceId.map(value => value)
      )
    def description: Option[String]
    def eventId: Option[String]
    def eventType: Option[String]
    def notAfter: Option[MillisecondDateTime]
    def notBefore: Option[MillisecondDateTime]
    def instanceId: Option[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEventId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getEventType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getNotAfter: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getNotBefore: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusEvent
  ) extends zio.aws.ec2.model.VolumeStatusEvent.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val eventId: Option[String] =
      scala.Option(impl.eventId()).map(value => value: String)
    override val eventType: Option[String] =
      scala.Option(impl.eventType()).map(value => value: String)
    override val notAfter: Option[MillisecondDateTime] = scala
      .Option(impl.notAfter())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val notBefore: Option[MillisecondDateTime] = scala
      .Option(impl.notBefore())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusEvent
  ): zio.aws.ec2.model.VolumeStatusEvent.ReadOnly = new Wrapper(impl)
}
