package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{DateTime, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class VolumeModification(
    volumeId: Option[String] = None,
    modificationState: Option[zio.aws.ec2.model.VolumeModificationState] = None,
    statusMessage: Option[String] = None,
    targetSize: Option[Integer] = None,
    targetIops: Option[Integer] = None,
    targetVolumeType: Option[zio.aws.ec2.model.VolumeType] = None,
    targetThroughput: Option[Integer] = None,
    targetMultiAttachEnabled: Option[Boolean] = None,
    originalSize: Option[Integer] = None,
    originalIops: Option[Integer] = None,
    originalVolumeType: Option[zio.aws.ec2.model.VolumeType] = None,
    originalThroughput: Option[Integer] = None,
    originalMultiAttachEnabled: Option[Boolean] = None,
    progress: Option[Long] = None,
    startTime: Option[DateTime] = None,
    endTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VolumeModification = {
    import VolumeModification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VolumeModification
      .builder()
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .optionallyWith(modificationState.map(value => value.unwrap))(
        _.modificationState
      )
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        targetSize.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.targetSize)
      .optionallyWith(
        targetIops.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.targetIops)
      .optionallyWith(targetVolumeType.map(value => value.unwrap))(
        _.targetVolumeType
      )
      .optionallyWith(
        targetThroughput.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.targetThroughput)
      .optionallyWith(
        targetMultiAttachEnabled.map(value => value: java.lang.Boolean)
      )(_.targetMultiAttachEnabled)
      .optionallyWith(
        originalSize.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.originalSize)
      .optionallyWith(
        originalIops.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.originalIops)
      .optionallyWith(originalVolumeType.map(value => value.unwrap))(
        _.originalVolumeType
      )
      .optionallyWith(
        originalThroughput.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.originalThroughput)
      .optionallyWith(
        originalMultiAttachEnabled.map(value => value: java.lang.Boolean)
      )(_.originalMultiAttachEnabled)
      .optionallyWith(progress.map(value => value: java.lang.Long))(_.progress)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => DateTime.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VolumeModification.ReadOnly =
    zio.aws.ec2.model.VolumeModification.wrap(buildAwsValue())
}
object VolumeModification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VolumeModification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VolumeModification =
      zio.aws.ec2.model.VolumeModification(
        volumeId.map(value => value),
        modificationState.map(value => value),
        statusMessage.map(value => value),
        targetSize.map(value => value),
        targetIops.map(value => value),
        targetVolumeType.map(value => value),
        targetThroughput.map(value => value),
        targetMultiAttachEnabled.map(value => value),
        originalSize.map(value => value),
        originalIops.map(value => value),
        originalVolumeType.map(value => value),
        originalThroughput.map(value => value),
        originalMultiAttachEnabled.map(value => value),
        progress.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def volumeId: Option[String]
    def modificationState: Option[zio.aws.ec2.model.VolumeModificationState]
    def statusMessage: Option[String]
    def targetSize: Option[Integer]
    def targetIops: Option[Integer]
    def targetVolumeType: Option[zio.aws.ec2.model.VolumeType]
    def targetThroughput: Option[Integer]
    def targetMultiAttachEnabled: Option[Boolean]
    def originalSize: Option[Integer]
    def originalIops: Option[Integer]
    def originalVolumeType: Option[zio.aws.ec2.model.VolumeType]
    def originalThroughput: Option[Integer]
    def originalMultiAttachEnabled: Option[Boolean]
    def progress: Option[Long]
    def startTime: Option[DateTime]
    def endTime: Option[DateTime]
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getModificationState
        : ZIO[Any, AwsError, zio.aws.ec2.model.VolumeModificationState] =
      AwsError.unwrapOptionField("modificationState", modificationState)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTargetSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetSize", targetSize)
    def getTargetIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetIops", targetIops)
    def getTargetVolumeType: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeType] =
      AwsError.unwrapOptionField("targetVolumeType", targetVolumeType)
    def getTargetThroughput: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetThroughput", targetThroughput)
    def getTargetMultiAttachEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("targetMultiAttachEnabled", targetMultiAttachEnabled)
    def getOriginalSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("originalSize", originalSize)
    def getOriginalIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("originalIops", originalIops)
    def getOriginalVolumeType
        : ZIO[Any, AwsError, zio.aws.ec2.model.VolumeType] =
      AwsError.unwrapOptionField("originalVolumeType", originalVolumeType)
    def getOriginalThroughput: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("originalThroughput", originalThroughput)
    def getOriginalMultiAttachEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "originalMultiAttachEnabled",
        originalMultiAttachEnabled
      )
    def getProgress: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("progress", progress)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VolumeModification
  ) extends zio.aws.ec2.model.VolumeModification.ReadOnly {
    override val volumeId: Option[String] =
      scala.Option(impl.volumeId()).map(value => value: String)
    override val modificationState
        : Option[zio.aws.ec2.model.VolumeModificationState] = scala
      .Option(impl.modificationState())
      .map(value => zio.aws.ec2.model.VolumeModificationState.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val targetSize: Option[Integer] = scala
      .Option(impl.targetSize())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val targetIops: Option[Integer] = scala
      .Option(impl.targetIops())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val targetVolumeType: Option[zio.aws.ec2.model.VolumeType] = scala
      .Option(impl.targetVolumeType())
      .map(value => zio.aws.ec2.model.VolumeType.wrap(value))
    override val targetThroughput: Option[Integer] = scala
      .Option(impl.targetThroughput())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val targetMultiAttachEnabled: Option[Boolean] =
      scala.Option(impl.targetMultiAttachEnabled()).map(value => value: Boolean)
    override val originalSize: Option[Integer] = scala
      .Option(impl.originalSize())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val originalIops: Option[Integer] = scala
      .Option(impl.originalIops())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val originalVolumeType: Option[zio.aws.ec2.model.VolumeType] =
      scala
        .Option(impl.originalVolumeType())
        .map(value => zio.aws.ec2.model.VolumeType.wrap(value))
    override val originalThroughput: Option[Integer] = scala
      .Option(impl.originalThroughput())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val originalMultiAttachEnabled: Option[Boolean] = scala
      .Option(impl.originalMultiAttachEnabled())
      .map(value => value: Boolean)
    override val progress: Option[Long] =
      scala.Option(impl.progress()).map(value => value: Long)
    override val startTime: Option[DateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val endTime: Option[DateTime] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VolumeModification
  ): zio.aws.ec2.model.VolumeModification.ReadOnly = new Wrapper(impl)
}
