package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TargetCapacitySpecification(
    totalTargetCapacity: Option[Integer] = None,
    onDemandTargetCapacity: Option[Integer] = None,
    spotTargetCapacity: Option[Integer] = None,
    defaultTargetCapacityType: Option[
      zio.aws.ec2.model.DefaultTargetCapacityType
    ] = None,
    targetCapacityUnitType: Option[zio.aws.ec2.model.TargetCapacityUnitType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TargetCapacitySpecification = {
    import TargetCapacitySpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TargetCapacitySpecification
      .builder()
      .optionallyWith(
        totalTargetCapacity.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.totalTargetCapacity)
      .optionallyWith(
        onDemandTargetCapacity.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.onDemandTargetCapacity)
      .optionallyWith(
        spotTargetCapacity.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.spotTargetCapacity)
      .optionallyWith(defaultTargetCapacityType.map(value => value.unwrap))(
        _.defaultTargetCapacityType
      )
      .optionallyWith(targetCapacityUnitType.map(value => value.unwrap))(
        _.targetCapacityUnitType
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TargetCapacitySpecification.ReadOnly =
    zio.aws.ec2.model.TargetCapacitySpecification.wrap(buildAwsValue())
}
object TargetCapacitySpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TargetCapacitySpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TargetCapacitySpecification =
      zio.aws.ec2.model.TargetCapacitySpecification(
        totalTargetCapacity.map(value => value),
        onDemandTargetCapacity.map(value => value),
        spotTargetCapacity.map(value => value),
        defaultTargetCapacityType.map(value => value),
        targetCapacityUnitType.map(value => value)
      )
    def totalTargetCapacity: Option[Integer]
    def onDemandTargetCapacity: Option[Integer]
    def spotTargetCapacity: Option[Integer]
    def defaultTargetCapacityType
        : Option[zio.aws.ec2.model.DefaultTargetCapacityType]
    def targetCapacityUnitType: Option[zio.aws.ec2.model.TargetCapacityUnitType]
    def getTotalTargetCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalTargetCapacity", totalTargetCapacity)
    def getOnDemandTargetCapacity: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("onDemandTargetCapacity", onDemandTargetCapacity)
    def getSpotTargetCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("spotTargetCapacity", spotTargetCapacity)
    def getDefaultTargetCapacityType
        : ZIO[Any, AwsError, zio.aws.ec2.model.DefaultTargetCapacityType] =
      AwsError.unwrapOptionField(
        "defaultTargetCapacityType",
        defaultTargetCapacityType
      )
    def getTargetCapacityUnitType
        : ZIO[Any, AwsError, zio.aws.ec2.model.TargetCapacityUnitType] =
      AwsError.unwrapOptionField(
        "targetCapacityUnitType",
        targetCapacityUnitType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TargetCapacitySpecification
  ) extends zio.aws.ec2.model.TargetCapacitySpecification.ReadOnly {
    override val totalTargetCapacity: Option[Integer] = scala
      .Option(impl.totalTargetCapacity())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val onDemandTargetCapacity: Option[Integer] = scala
      .Option(impl.onDemandTargetCapacity())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val spotTargetCapacity: Option[Integer] = scala
      .Option(impl.spotTargetCapacity())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val defaultTargetCapacityType
        : Option[zio.aws.ec2.model.DefaultTargetCapacityType] = scala
      .Option(impl.defaultTargetCapacityType())
      .map(value => zio.aws.ec2.model.DefaultTargetCapacityType.wrap(value))
    override val targetCapacityUnitType
        : Option[zio.aws.ec2.model.TargetCapacityUnitType] = scala
      .Option(impl.targetCapacityUnitType())
      .map(value => zio.aws.ec2.model.TargetCapacityUnitType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TargetCapacitySpecification
  ): zio.aws.ec2.model.TargetCapacitySpecification.ReadOnly = new Wrapper(impl)
}
