package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ShutdownBehavior {
  def unwrap: software.amazon.awssdk.services.ec2.model.ShutdownBehavior
}
object ShutdownBehavior {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ShutdownBehavior
  ): zio.aws.ec2.model.ShutdownBehavior = value match {
    case software.amazon.awssdk.services.ec2.model.ShutdownBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ShutdownBehavior.STOP =>
      val r = stop
      r
    case software.amazon.awssdk.services.ec2.model.ShutdownBehavior.TERMINATE =>
      val r = terminate
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ShutdownBehavior {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ShutdownBehavior =
      software.amazon.awssdk.services.ec2.model.ShutdownBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object stop extends zio.aws.ec2.model.ShutdownBehavior {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ShutdownBehavior =
      software.amazon.awssdk.services.ec2.model.ShutdownBehavior.STOP
  }
  case object terminate extends zio.aws.ec2.model.ShutdownBehavior {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ShutdownBehavior =
      software.amazon.awssdk.services.ec2.model.ShutdownBehavior.TERMINATE
  }
}
