package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SnapshotId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RestoreSnapshotFromRecycleBinRequest(snapshotId: SnapshotId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinRequest = {
    import RestoreSnapshotFromRecycleBinRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinRequest
      .builder()
      .snapshotId(SnapshotId.unwrap(snapshotId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest.ReadOnly =
    zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest.wrap(buildAwsValue())
}
object RestoreSnapshotFromRecycleBinRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest =
      zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest(snapshotId)
    def snapshotId: SnapshotId
    def getSnapshotId: ZIO[Any, Nothing, SnapshotId] = ZIO.succeed(snapshotId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinRequest
  ) extends zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest.ReadOnly {
    override val snapshotId: SnapshotId =
      zio.aws.ec2.model.primitives.SnapshotId(impl.snapshotId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinRequest
  ): zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest.ReadOnly =
    new Wrapper(impl)
}
