package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SubnetId,
  KeyPairName,
  SecurityGroupId,
  KernelId,
  ImageId,
  RamdiskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RequestSpotLaunchSpecification(
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    securityGroups: Option[Iterable[String]] = None,
    addressingType: Option[String] = None,
    blockDeviceMappings: Option[
      Iterable[zio.aws.ec2.model.BlockDeviceMapping]
    ] = None,
    ebsOptimized: Option[Boolean] = None,
    iamInstanceProfile: Option[
      zio.aws.ec2.model.IamInstanceProfileSpecification
    ] = None,
    imageId: Option[ImageId] = None,
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    kernelId: Option[KernelId] = None,
    keyName: Option[KeyPairName] = None,
    monitoring: Option[zio.aws.ec2.model.RunInstancesMonitoringEnabled] = None,
    networkInterfaces: Option[
      Iterable[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification]
    ] = None,
    placement: Option[zio.aws.ec2.model.SpotPlacement] = None,
    ramdiskId: Option[RamdiskId] = None,
    subnetId: Option[SubnetId] = None,
    userData: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RequestSpotLaunchSpecification = {
    import RequestSpotLaunchSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RequestSpotLaunchSpecification
      .builder()
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(addressingType.map(value => value: java.lang.String))(
        _.addressingType
      )
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        kernelId.map(value => KernelId.unwrap(value): java.lang.String)
      )(_.kernelId)
      .optionallyWith(
        keyName.map(value => KeyPairName.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(
        ramdiskId.map(value => RamdiskId.unwrap(value): java.lang.String)
      )(_.ramdiskId)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RequestSpotLaunchSpecification.ReadOnly =
    zio.aws.ec2.model.RequestSpotLaunchSpecification.wrap(buildAwsValue())
}
object RequestSpotLaunchSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RequestSpotLaunchSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RequestSpotLaunchSpecification =
      zio.aws.ec2.model.RequestSpotLaunchSpecification(
        securityGroupIds.map(value => value),
        securityGroups.map(value => value),
        addressingType.map(value => value),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        imageId.map(value => value),
        instanceType.map(value => value),
        kernelId.map(value => value),
        keyName.map(value => value),
        monitoring.map(value => value.asEditable),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placement.map(value => value.asEditable),
        ramdiskId.map(value => value),
        subnetId.map(value => value),
        userData.map(value => value)
      )
    def securityGroupIds: Option[List[SecurityGroupId]]
    def securityGroups: Option[List[String]]
    def addressingType: Option[String]
    def blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]]
    def ebsOptimized: Option[Boolean]
    def iamInstanceProfile
        : Option[zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly]
    def imageId: Option[ImageId]
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def kernelId: Option[KernelId]
    def keyName: Option[KeyPairName]
    def monitoring
        : Option[zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly]
    def networkInterfaces: Option[
      List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly]
    ]
    def placement: Option[zio.aws.ec2.model.SpotPlacement.ReadOnly]
    def ramdiskId: Option[RamdiskId]
    def subnetId: Option[SubnetId]
    def userData: Option[String]
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getAddressingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addressingType", addressingType)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.BlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernelId: ZIO[Any, AwsError, KernelId] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getKeyName: ZIO[Any, AwsError, KeyPairName] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly
    ] = AwsError.unwrapOptionField("monitoring", monitoring)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getPlacement
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotPlacement.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getRamdiskId: ZIO[Any, AwsError, RamdiskId] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getUserData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RequestSpotLaunchSpecification
  ) extends zio.aws.ec2.model.RequestSpotLaunchSpecification.ReadOnly {
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val securityGroups: Option[List[String]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val addressingType: Option[String] =
      scala.Option(impl.addressingType()).map(value => value: String)
    override val blockDeviceMappings
        : Option[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.BlockDeviceMapping.wrap(item)
        }.toList
      )
    override val ebsOptimized: Option[Boolean] =
      scala.Option(impl.ebsOptimized()).map(value => value: Boolean)
    override val iamInstanceProfile
        : Option[zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly] =
      scala
        .Option(impl.iamInstanceProfile())
        .map(value =>
          zio.aws.ec2.model.IamInstanceProfileSpecification.wrap(value)
        )
    override val imageId: Option[ImageId] = scala
      .Option(impl.imageId())
      .map(value => zio.aws.ec2.model.primitives.ImageId(value))
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val kernelId: Option[KernelId] = scala
      .Option(impl.kernelId())
      .map(value => zio.aws.ec2.model.primitives.KernelId(value))
    override val keyName: Option[KeyPairName] = scala
      .Option(impl.keyName())
      .map(value => zio.aws.ec2.model.primitives.KeyPairName(value))
    override val monitoring
        : Option[zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly] =
      scala
        .Option(impl.monitoring())
        .map(value =>
          zio.aws.ec2.model.RunInstancesMonitoringEnabled.wrap(value)
        )
    override val networkInterfaces: Option[
      List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly]
    ] = scala
      .Option(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.wrap(item)
        }.toList
      )
    override val placement: Option[zio.aws.ec2.model.SpotPlacement.ReadOnly] =
      scala
        .Option(impl.placement())
        .map(value => zio.aws.ec2.model.SpotPlacement.wrap(value))
    override val ramdiskId: Option[RamdiskId] = scala
      .Option(impl.ramdiskId())
      .map(value => zio.aws.ec2.model.primitives.RamdiskId(value))
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val userData: Option[String] =
      scala.Option(impl.userData()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RequestSpotLaunchSpecification
  ): zio.aws.ec2.model.RequestSpotLaunchSpecification.ReadOnly = new Wrapper(
    impl
  )
}
