package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PriceSchedule(
    active: Option[Boolean] = None,
    currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues] = None,
    price: Option[Double] = None,
    term: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PriceSchedule = {
    import PriceSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PriceSchedule
      .builder()
      .optionallyWith(active.map(value => value: java.lang.Boolean))(_.active)
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .optionallyWith(price.map(value => value: java.lang.Double))(_.price)
      .optionallyWith(term.map(value => value: java.lang.Long))(_.term)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PriceSchedule.ReadOnly =
    zio.aws.ec2.model.PriceSchedule.wrap(buildAwsValue())
}
object PriceSchedule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.PriceSchedule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PriceSchedule =
      zio.aws.ec2.model.PriceSchedule(
        active.map(value => value),
        currencyCode.map(value => value),
        price.map(value => value),
        term.map(value => value)
      )
    def active: Option[Boolean]
    def currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues]
    def price: Option[Double]
    def term: Option[Long]
    def getActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("active", active)
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("price", price)
    def getTerm: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("term", term)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PriceSchedule
  ) extends zio.aws.ec2.model.PriceSchedule.ReadOnly {
    override val active: Option[Boolean] =
      scala.Option(impl.active()).map(value => value: Boolean)
    override val currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues] =
      scala
        .Option(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
    override val price: Option[Double] =
      scala.Option(impl.price()).map(value => value: Double)
    override val term: Option[Long] =
      scala.Option(impl.term()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PriceSchedule
  ): zio.aws.ec2.model.PriceSchedule.ReadOnly = new Wrapper(impl)
}
