package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Phase2IntegrityAlgorithmsRequestListValue(
    value: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Phase2IntegrityAlgorithmsRequestListValue = {
    import Phase2IntegrityAlgorithmsRequestListValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Phase2IntegrityAlgorithmsRequestListValue
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.Phase2IntegrityAlgorithmsRequestListValue.ReadOnly =
    zio.aws.ec2.model.Phase2IntegrityAlgorithmsRequestListValue
      .wrap(buildAwsValue())
}
object Phase2IntegrityAlgorithmsRequestListValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Phase2IntegrityAlgorithmsRequestListValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.Phase2IntegrityAlgorithmsRequestListValue =
      zio.aws.ec2.model
        .Phase2IntegrityAlgorithmsRequestListValue(value.map(value => value))
    def value: Option[String]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Phase2IntegrityAlgorithmsRequestListValue
  ) extends zio.aws.ec2.model.Phase2IntegrityAlgorithmsRequestListValue.ReadOnly {
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Phase2IntegrityAlgorithmsRequestListValue
  ): zio.aws.ec2.model.Phase2IntegrityAlgorithmsRequestListValue.ReadOnly =
    new Wrapper(impl)
}
