package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NewDhcpConfiguration(
    key: Option[String] = None,
    values: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NewDhcpConfiguration = {
    import NewDhcpConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NewDhcpConfiguration
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NewDhcpConfiguration.ReadOnly =
    zio.aws.ec2.model.NewDhcpConfiguration.wrap(buildAwsValue())
}
object NewDhcpConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NewDhcpConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NewDhcpConfiguration = zio.aws.ec2.model
      .NewDhcpConfiguration(key.map(value => value), values.map(value => value))
    def key: Option[String]
    def values: Option[List[String]]
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NewDhcpConfiguration
  ) extends zio.aws.ec2.model.NewDhcpConfiguration.ReadOnly {
    override val key: Option[String] =
      scala.Option(impl.key()).map(value => value: String)
    override val values: Option[List[String]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NewDhcpConfiguration
  ): zio.aws.ec2.model.NewDhcpConfiguration.ReadOnly = new Wrapper(impl)
}
