package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInterfaceAttachmentId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkInterfaceAttachmentChanges(
    attachmentId: Option[NetworkInterfaceAttachmentId] = None,
    deleteOnTermination: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachmentChanges = {
    import NetworkInterfaceAttachmentChanges.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachmentChanges
      .builder()
      .optionallyWith(
        attachmentId.map(value =>
          NetworkInterfaceAttachmentId.unwrap(value): java.lang.String
        )
      )(_.attachmentId)
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInterfaceAttachmentChanges.ReadOnly =
    zio.aws.ec2.model.NetworkInterfaceAttachmentChanges.wrap(buildAwsValue())
}
object NetworkInterfaceAttachmentChanges {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachmentChanges
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInterfaceAttachmentChanges =
      zio.aws.ec2.model.NetworkInterfaceAttachmentChanges(
        attachmentId.map(value => value),
        deleteOnTermination.map(value => value)
      )
    def attachmentId: Option[NetworkInterfaceAttachmentId]
    def deleteOnTermination: Option[Boolean]
    def getAttachmentId: ZIO[Any, AwsError, NetworkInterfaceAttachmentId] =
      AwsError.unwrapOptionField("attachmentId", attachmentId)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachmentChanges
  ) extends zio.aws.ec2.model.NetworkInterfaceAttachmentChanges.ReadOnly {
    override val attachmentId: Option[NetworkInterfaceAttachmentId] = scala
      .Option(impl.attachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInterfaceAttachmentId(value)
      )
    override val deleteOnTermination: Option[Boolean] =
      scala.Option(impl.deleteOnTermination()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachmentChanges
  ): zio.aws.ec2.model.NetworkInterfaceAttachmentChanges.ReadOnly = new Wrapper(
    impl
  )
}
