package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkInsightsAccessScopeContent(
    networkInsightsAccessScopeId: Option[NetworkInsightsAccessScopeId] = None,
    matchPaths: Option[Iterable[zio.aws.ec2.model.AccessScopePath]] = None,
    excludePaths: Option[Iterable[zio.aws.ec2.model.AccessScopePath]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeContent = {
    import NetworkInsightsAccessScopeContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeContent
      .builder()
      .optionallyWith(
        networkInsightsAccessScopeId.map(value =>
          NetworkInsightsAccessScopeId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeId)
      .optionallyWith(
        matchPaths.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.matchPaths)
      .optionallyWith(
        excludePaths.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludePaths)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInsightsAccessScopeContent.ReadOnly =
    zio.aws.ec2.model.NetworkInsightsAccessScopeContent.wrap(buildAwsValue())
}
object NetworkInsightsAccessScopeContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInsightsAccessScopeContent =
      zio.aws.ec2.model.NetworkInsightsAccessScopeContent(
        networkInsightsAccessScopeId.map(value => value),
        matchPaths.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        excludePaths.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def networkInsightsAccessScopeId: Option[NetworkInsightsAccessScopeId]
    def matchPaths: Option[List[zio.aws.ec2.model.AccessScopePath.ReadOnly]]
    def excludePaths: Option[List[zio.aws.ec2.model.AccessScopePath.ReadOnly]]
    def getNetworkInsightsAccessScopeId
        : ZIO[Any, AwsError, NetworkInsightsAccessScopeId] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeId",
        networkInsightsAccessScopeId
      )
    def getMatchPaths
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AccessScopePath.ReadOnly]] =
      AwsError.unwrapOptionField("matchPaths", matchPaths)
    def getExcludePaths
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AccessScopePath.ReadOnly]] =
      AwsError.unwrapOptionField("excludePaths", excludePaths)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeContent
  ) extends zio.aws.ec2.model.NetworkInsightsAccessScopeContent.ReadOnly {
    override val networkInsightsAccessScopeId
        : Option[NetworkInsightsAccessScopeId] = scala
      .Option(impl.networkInsightsAccessScopeId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId(value)
      )
    override val matchPaths
        : Option[List[zio.aws.ec2.model.AccessScopePath.ReadOnly]] = scala
      .Option(impl.matchPaths())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AccessScopePath.wrap(item)
        }.toList
      )
    override val excludePaths
        : Option[List[zio.aws.ec2.model.AccessScopePath.ReadOnly]] = scala
      .Option(impl.excludePaths())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AccessScopePath.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeContent
  ): zio.aws.ec2.model.NetworkInsightsAccessScopeContent.ReadOnly = new Wrapper(
    impl
  )
}
