package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MonitorInstancesResponse(
    instanceMonitorings: Option[
      Iterable[zio.aws.ec2.model.InstanceMonitoring]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.MonitorInstancesResponse = {
    import MonitorInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.MonitorInstancesResponse
      .builder()
      .optionallyWith(
        instanceMonitorings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceMonitorings)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.MonitorInstancesResponse.ReadOnly =
    zio.aws.ec2.model.MonitorInstancesResponse.wrap(buildAwsValue())
}
object MonitorInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.MonitorInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.MonitorInstancesResponse =
      zio.aws.ec2.model.MonitorInstancesResponse(
        instanceMonitorings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def instanceMonitorings
        : Option[List[zio.aws.ec2.model.InstanceMonitoring.ReadOnly]]
    def getInstanceMonitorings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceMonitoring.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceMonitorings", instanceMonitorings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.MonitorInstancesResponse
  ) extends zio.aws.ec2.model.MonitorInstancesResponse.ReadOnly {
    override val instanceMonitorings
        : Option[List[zio.aws.ec2.model.InstanceMonitoring.ReadOnly]] = scala
      .Option(impl.instanceMonitorings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceMonitoring.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.MonitorInstancesResponse
  ): zio.aws.ec2.model.MonitorInstancesResponse.ReadOnly = new Wrapper(impl)
}
