package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyTransitGatewayVpcAttachmentRequestOptions(
    dnsSupport: Option[zio.aws.ec2.model.DnsSupportValue] = None,
    ipv6Support: Option[zio.aws.ec2.model.Ipv6SupportValue] = None,
    applianceModeSupport: Option[zio.aws.ec2.model.ApplianceModeSupportValue] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions = {
    import ModifyTransitGatewayVpcAttachmentRequestOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions
      .builder()
      .optionallyWith(dnsSupport.map(value => value.unwrap))(_.dnsSupport)
      .optionallyWith(ipv6Support.map(value => value.unwrap))(_.ipv6Support)
      .optionallyWith(applianceModeSupport.map(value => value.unwrap))(
        _.applianceModeSupport
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions.ReadOnly =
    zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions
      .wrap(buildAwsValue())
}
object ModifyTransitGatewayVpcAttachmentRequestOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions =
      zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions(
        dnsSupport.map(value => value),
        ipv6Support.map(value => value),
        applianceModeSupport.map(value => value)
      )
    def dnsSupport: Option[zio.aws.ec2.model.DnsSupportValue]
    def ipv6Support: Option[zio.aws.ec2.model.Ipv6SupportValue]
    def applianceModeSupport
        : Option[zio.aws.ec2.model.ApplianceModeSupportValue]
    def getDnsSupport: ZIO[Any, AwsError, zio.aws.ec2.model.DnsSupportValue] =
      AwsError.unwrapOptionField("dnsSupport", dnsSupport)
    def getIpv6Support: ZIO[Any, AwsError, zio.aws.ec2.model.Ipv6SupportValue] =
      AwsError.unwrapOptionField("ipv6Support", ipv6Support)
    def getApplianceModeSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.ApplianceModeSupportValue] =
      AwsError.unwrapOptionField("applianceModeSupport", applianceModeSupport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions
  ) extends zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions.ReadOnly {
    override val dnsSupport: Option[zio.aws.ec2.model.DnsSupportValue] = scala
      .Option(impl.dnsSupport())
      .map(value => zio.aws.ec2.model.DnsSupportValue.wrap(value))
    override val ipv6Support: Option[zio.aws.ec2.model.Ipv6SupportValue] = scala
      .Option(impl.ipv6Support())
      .map(value => zio.aws.ec2.model.Ipv6SupportValue.wrap(value))
    override val applianceModeSupport
        : Option[zio.aws.ec2.model.ApplianceModeSupportValue] = scala
      .Option(impl.applianceModeSupport())
      .map(value => zio.aws.ec2.model.ApplianceModeSupportValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions
  ): zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions.ReadOnly =
    new Wrapper(impl)
}
