package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyTrafficMirrorSessionResponse(
    trafficMirrorSession: Option[zio.aws.ec2.model.TrafficMirrorSession] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse = {
    import ModifyTrafficMirrorSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse
      .builder()
      .optionallyWith(trafficMirrorSession.map(value => value.buildAwsValue()))(
        _.trafficMirrorSession
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse.ReadOnly =
    zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse.wrap(buildAwsValue())
}
object ModifyTrafficMirrorSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse =
      zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse(
        trafficMirrorSession.map(value => value.asEditable)
      )
    def trafficMirrorSession
        : Option[zio.aws.ec2.model.TrafficMirrorSession.ReadOnly]
    def getTrafficMirrorSession
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficMirrorSession.ReadOnly] =
      AwsError.unwrapOptionField("trafficMirrorSession", trafficMirrorSession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse
  ) extends zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse.ReadOnly {
    override val trafficMirrorSession
        : Option[zio.aws.ec2.model.TrafficMirrorSession.ReadOnly] = scala
      .Option(impl.trafficMirrorSession())
      .map(value => zio.aws.ec2.model.TrafficMirrorSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse
  ): zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse.ReadOnly =
    new Wrapper(impl)
}
