package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamPoolAwsService {
  def unwrap: software.amazon.awssdk.services.ec2.model.IpamPoolAwsService
}
object IpamPoolAwsService {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamPoolAwsService
  ): zio.aws.ec2.model.IpamPoolAwsService = value match {
    case software.amazon.awssdk.services.ec2.model.IpamPoolAwsService.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamPoolAwsService.EC2 =>
      val r = ec2
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.IpamPoolAwsService {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolAwsService =
      software.amazon.awssdk.services.ec2.model.IpamPoolAwsService.UNKNOWN_TO_SDK_VERSION
  }
  case object ec2 extends zio.aws.ec2.model.IpamPoolAwsService {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamPoolAwsService =
      software.amazon.awssdk.services.ec2.model.IpamPoolAwsService.EC2
  }
}
