package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InternetGateway(
    attachments: Option[Iterable[zio.aws.ec2.model.InternetGatewayAttachment]] =
      None,
    internetGatewayId: Option[String] = None,
    ownerId: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InternetGateway = {
    import InternetGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InternetGateway
      .builder()
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .optionallyWith(internetGatewayId.map(value => value: java.lang.String))(
        _.internetGatewayId
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InternetGateway.ReadOnly =
    zio.aws.ec2.model.InternetGateway.wrap(buildAwsValue())
}
object InternetGateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InternetGateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InternetGateway =
      zio.aws.ec2.model.InternetGateway(
        attachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        internetGatewayId.map(value => value),
        ownerId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def attachments
        : Option[List[zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly]]
    def internetGatewayId: Option[String]
    def ownerId: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getAttachments: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("attachments", attachments)
    def getInternetGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("internetGatewayId", internetGatewayId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InternetGateway
  ) extends zio.aws.ec2.model.InternetGateway.ReadOnly {
    override val attachments
        : Option[List[zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly]] =
      scala
        .Option(impl.attachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InternetGatewayAttachment.wrap(item)
          }.toList
        )
    override val internetGatewayId: Option[String] =
      scala.Option(impl.internetGatewayId()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InternetGateway
  ): zio.aws.ec2.model.InternetGateway.ReadOnly = new Wrapper(impl)
}
