package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceMetadataOptionsResponse(
    state: Option[zio.aws.ec2.model.InstanceMetadataOptionsState] = None,
    httpTokens: Option[zio.aws.ec2.model.HttpTokensState] = None,
    httpPutResponseHopLimit: Option[Integer] = None,
    httpEndpoint: Option[zio.aws.ec2.model.InstanceMetadataEndpointState] =
      None,
    httpProtocolIpv6: Option[zio.aws.ec2.model.InstanceMetadataProtocolState] =
      None,
    instanceMetadataTags: Option[zio.aws.ec2.model.InstanceMetadataTagsState] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsResponse = {
    import InstanceMetadataOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsResponse
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(httpTokens.map(value => value.unwrap))(_.httpTokens)
      .optionallyWith(
        httpPutResponseHopLimit.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.httpPutResponseHopLimit)
      .optionallyWith(httpEndpoint.map(value => value.unwrap))(_.httpEndpoint)
      .optionallyWith(httpProtocolIpv6.map(value => value.unwrap))(
        _.httpProtocolIpv6
      )
      .optionallyWith(instanceMetadataTags.map(value => value.unwrap))(
        _.instanceMetadataTags
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly =
    zio.aws.ec2.model.InstanceMetadataOptionsResponse.wrap(buildAwsValue())
}
object InstanceMetadataOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceMetadataOptionsResponse =
      zio.aws.ec2.model.InstanceMetadataOptionsResponse(
        state.map(value => value),
        httpTokens.map(value => value),
        httpPutResponseHopLimit.map(value => value),
        httpEndpoint.map(value => value),
        httpProtocolIpv6.map(value => value),
        instanceMetadataTags.map(value => value)
      )
    def state: Option[zio.aws.ec2.model.InstanceMetadataOptionsState]
    def httpTokens: Option[zio.aws.ec2.model.HttpTokensState]
    def httpPutResponseHopLimit: Option[Integer]
    def httpEndpoint: Option[zio.aws.ec2.model.InstanceMetadataEndpointState]
    def httpProtocolIpv6
        : Option[zio.aws.ec2.model.InstanceMetadataProtocolState]
    def instanceMetadataTags
        : Option[zio.aws.ec2.model.InstanceMetadataTagsState]
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceMetadataOptionsState] =
      AwsError.unwrapOptionField("state", state)
    def getHttpTokens: ZIO[Any, AwsError, zio.aws.ec2.model.HttpTokensState] =
      AwsError.unwrapOptionField("httpTokens", httpTokens)
    def getHttpPutResponseHopLimit: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("httpPutResponseHopLimit", httpPutResponseHopLimit)
    def getHttpEndpoint
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceMetadataEndpointState] =
      AwsError.unwrapOptionField("httpEndpoint", httpEndpoint)
    def getHttpProtocolIpv6
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceMetadataProtocolState] =
      AwsError.unwrapOptionField("httpProtocolIpv6", httpProtocolIpv6)
    def getInstanceMetadataTags
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceMetadataTagsState] =
      AwsError.unwrapOptionField("instanceMetadataTags", instanceMetadataTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsResponse
  ) extends zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly {
    override val state: Option[zio.aws.ec2.model.InstanceMetadataOptionsState] =
      scala
        .Option(impl.state())
        .map(value =>
          zio.aws.ec2.model.InstanceMetadataOptionsState.wrap(value)
        )
    override val httpTokens: Option[zio.aws.ec2.model.HttpTokensState] = scala
      .Option(impl.httpTokens())
      .map(value => zio.aws.ec2.model.HttpTokensState.wrap(value))
    override val httpPutResponseHopLimit: Option[Integer] = scala
      .Option(impl.httpPutResponseHopLimit())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val httpEndpoint
        : Option[zio.aws.ec2.model.InstanceMetadataEndpointState] = scala
      .Option(impl.httpEndpoint())
      .map(value => zio.aws.ec2.model.InstanceMetadataEndpointState.wrap(value))
    override val httpProtocolIpv6
        : Option[zio.aws.ec2.model.InstanceMetadataProtocolState] = scala
      .Option(impl.httpProtocolIpv6())
      .map(value => zio.aws.ec2.model.InstanceMetadataProtocolState.wrap(value))
    override val instanceMetadataTags
        : Option[zio.aws.ec2.model.InstanceMetadataTagsState] = scala
      .Option(impl.instanceMetadataTags())
      .map(value => zio.aws.ec2.model.InstanceMetadataTagsState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsResponse
  ): zio.aws.ec2.model.InstanceMetadataOptionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
