package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceExportDetails(
    instanceId: Option[String] = None,
    targetEnvironment: Option[zio.aws.ec2.model.ExportEnvironment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceExportDetails = {
    import InstanceExportDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceExportDetails
      .builder()
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(targetEnvironment.map(value => value.unwrap))(
        _.targetEnvironment
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceExportDetails.ReadOnly =
    zio.aws.ec2.model.InstanceExportDetails.wrap(buildAwsValue())
}
object InstanceExportDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceExportDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceExportDetails =
      zio.aws.ec2.model.InstanceExportDetails(
        instanceId.map(value => value),
        targetEnvironment.map(value => value)
      )
    def instanceId: Option[String]
    def targetEnvironment: Option[zio.aws.ec2.model.ExportEnvironment]
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getTargetEnvironment
        : ZIO[Any, AwsError, zio.aws.ec2.model.ExportEnvironment] =
      AwsError.unwrapOptionField("targetEnvironment", targetEnvironment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceExportDetails
  ) extends zio.aws.ec2.model.InstanceExportDetails.ReadOnly {
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val targetEnvironment
        : Option[zio.aws.ec2.model.ExportEnvironment] = scala
      .Option(impl.targetEnvironment())
      .map(value => zio.aws.ec2.model.ExportEnvironment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceExportDetails
  ): zio.aws.ec2.model.InstanceExportDetails.ReadOnly = new Wrapper(impl)
}
