package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  OfferingId,
  HostReservationId,
  DateTime,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class HostReservation(
    count: Option[Integer] = None,
    currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues] = None,
    duration: Option[Integer] = None,
    end: Option[DateTime] = None,
    hostIdSet: Option[Iterable[String]] = None,
    hostReservationId: Option[HostReservationId] = None,
    hourlyPrice: Option[String] = None,
    instanceFamily: Option[String] = None,
    offeringId: Option[OfferingId] = None,
    paymentOption: Option[zio.aws.ec2.model.PaymentOption] = None,
    start: Option[DateTime] = None,
    state: Option[zio.aws.ec2.model.ReservationState] = None,
    upfrontPrice: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.HostReservation = {
    import HostReservation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.HostReservation
      .builder()
      .optionallyWith(
        count.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.count)
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .optionallyWith(
        duration.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.duration)
      .optionallyWith(end.map(value => DateTime.unwrap(value): Instant))(_.end)
      .optionallyWith(
        hostIdSet.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.hostIdSet)
      .optionallyWith(
        hostReservationId.map(value =>
          HostReservationId.unwrap(value): java.lang.String
        )
      )(_.hostReservationId)
      .optionallyWith(hourlyPrice.map(value => value: java.lang.String))(
        _.hourlyPrice
      )
      .optionallyWith(instanceFamily.map(value => value: java.lang.String))(
        _.instanceFamily
      )
      .optionallyWith(
        offeringId.map(value => OfferingId.unwrap(value): java.lang.String)
      )(_.offeringId)
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(start.map(value => DateTime.unwrap(value): Instant))(
        _.start
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(upfrontPrice.map(value => value: java.lang.String))(
        _.upfrontPrice
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.HostReservation.ReadOnly =
    zio.aws.ec2.model.HostReservation.wrap(buildAwsValue())
}
object HostReservation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.HostReservation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.HostReservation =
      zio.aws.ec2.model.HostReservation(
        count.map(value => value),
        currencyCode.map(value => value),
        duration.map(value => value),
        end.map(value => value),
        hostIdSet.map(value => value),
        hostReservationId.map(value => value),
        hourlyPrice.map(value => value),
        instanceFamily.map(value => value),
        offeringId.map(value => value),
        paymentOption.map(value => value),
        start.map(value => value),
        state.map(value => value),
        upfrontPrice.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def count: Option[Integer]
    def currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues]
    def duration: Option[Integer]
    def end: Option[DateTime]
    def hostIdSet: Option[List[String]]
    def hostReservationId: Option[HostReservationId]
    def hourlyPrice: Option[String]
    def instanceFamily: Option[String]
    def offeringId: Option[OfferingId]
    def paymentOption: Option[zio.aws.ec2.model.PaymentOption]
    def start: Option[DateTime]
    def state: Option[zio.aws.ec2.model.ReservationState]
    def upfrontPrice: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getEnd: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("end", end)
    def getHostIdSet: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("hostIdSet", hostIdSet)
    def getHostReservationId: ZIO[Any, AwsError, HostReservationId] =
      AwsError.unwrapOptionField("hostReservationId", hostReservationId)
    def getHourlyPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hourlyPrice", hourlyPrice)
    def getInstanceFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceFamily", instanceFamily)
    def getOfferingId: ZIO[Any, AwsError, OfferingId] =
      AwsError.unwrapOptionField("offeringId", offeringId)
    def getPaymentOption: ZIO[Any, AwsError, zio.aws.ec2.model.PaymentOption] =
      AwsError.unwrapOptionField("paymentOption", paymentOption)
    def getStart: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("start", start)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.ReservationState] =
      AwsError.unwrapOptionField("state", state)
    def getUpfrontPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("upfrontPrice", upfrontPrice)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.HostReservation
  ) extends zio.aws.ec2.model.HostReservation.ReadOnly {
    override val count: Option[Integer] = scala
      .Option(impl.count())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues] =
      scala
        .Option(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
    override val duration: Option[Integer] = scala
      .Option(impl.duration())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val end: Option[DateTime] = scala
      .Option(impl.end())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val hostIdSet: Option[List[String]] = scala
      .Option(impl.hostIdSet())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val hostReservationId: Option[HostReservationId] = scala
      .Option(impl.hostReservationId())
      .map(value => zio.aws.ec2.model.primitives.HostReservationId(value))
    override val hourlyPrice: Option[String] =
      scala.Option(impl.hourlyPrice()).map(value => value: String)
    override val instanceFamily: Option[String] =
      scala.Option(impl.instanceFamily()).map(value => value: String)
    override val offeringId: Option[OfferingId] = scala
      .Option(impl.offeringId())
      .map(value => zio.aws.ec2.model.primitives.OfferingId(value))
    override val paymentOption: Option[zio.aws.ec2.model.PaymentOption] = scala
      .Option(impl.paymentOption())
      .map(value => zio.aws.ec2.model.PaymentOption.wrap(value))
    override val start: Option[DateTime] = scala
      .Option(impl.start())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val state: Option[zio.aws.ec2.model.ReservationState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.ReservationState.wrap(value))
    override val upfrontPrice: Option[String] =
      scala.Option(impl.upfrontPrice()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.HostReservation
  ): zio.aws.ec2.model.HostReservation.ReadOnly = new Wrapper(impl)
}
