package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{CoipPoolMaxResults, CoipPoolId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetCoipPoolUsageRequest(
    poolId: CoipPoolId,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[CoipPoolMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest = {
    import GetCoipPoolUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest
      .builder()
      .poolId(CoipPoolId.unwrap(poolId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => CoipPoolMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetCoipPoolUsageRequest.ReadOnly =
    zio.aws.ec2.model.GetCoipPoolUsageRequest.wrap(buildAwsValue())
}
object GetCoipPoolUsageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetCoipPoolUsageRequest =
      zio.aws.ec2.model.GetCoipPoolUsageRequest(
        poolId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def poolId: CoipPoolId
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[CoipPoolMaxResults]
    def nextToken: Option[String]
    def getPoolId: ZIO[Any, Nothing, CoipPoolId] = ZIO.succeed(poolId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, CoipPoolMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest
  ) extends zio.aws.ec2.model.GetCoipPoolUsageRequest.ReadOnly {
    override val poolId: CoipPoolId =
      zio.aws.ec2.model.primitives.CoipPoolId(impl.poolId())
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[CoipPoolMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.CoipPoolMaxResults(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetCoipPoolUsageRequest
  ): zio.aws.ec2.model.GetCoipPoolUsageRequest.ReadOnly = new Wrapper(impl)
}
