package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAssociatedEnclaveCertificateIamRolesRequest(
    certificateArn: Option[ResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest = {
    import GetAssociatedEnclaveCertificateIamRolesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
      .builder()
      .optionallyWith(
        certificateArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest.ReadOnly =
    zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
      .wrap(buildAwsValue())
}
object GetAssociatedEnclaveCertificateIamRolesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest =
      zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest(
        certificateArn.map(value => value)
      )
    def certificateArn: Option[ResourceArn]
    def getCertificateArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
  ) extends zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest.ReadOnly {
    override val certificateArn: Option[ResourceArn] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
  ): zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest.ReadOnly =
    new Wrapper(impl)
}
