package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{FleetId, DateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class FleetData(
    activityStatus: Option[zio.aws.ec2.model.FleetActivityStatus] = None,
    createTime: Option[DateTime] = None,
    fleetId: Option[FleetId] = None,
    fleetState: Option[zio.aws.ec2.model.FleetStateCode] = None,
    clientToken: Option[String] = None,
    excessCapacityTerminationPolicy: Option[
      zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy
    ] = None,
    fulfilledCapacity: Option[Double] = None,
    fulfilledOnDemandCapacity: Option[Double] = None,
    launchTemplateConfigs: Option[
      Iterable[zio.aws.ec2.model.FleetLaunchTemplateConfig]
    ] = None,
    targetCapacitySpecification: Option[
      zio.aws.ec2.model.TargetCapacitySpecification
    ] = None,
    terminateInstancesWithExpiration: Option[Boolean] = None,
    `type`: Option[zio.aws.ec2.model.FleetType] = None,
    validFrom: Option[DateTime] = None,
    validUntil: Option[DateTime] = None,
    replaceUnhealthyInstances: Option[Boolean] = None,
    spotOptions: Option[zio.aws.ec2.model.SpotOptions] = None,
    onDemandOptions: Option[zio.aws.ec2.model.OnDemandOptions] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    errors: Option[Iterable[zio.aws.ec2.model.DescribeFleetError]] = None,
    instances: Option[Iterable[zio.aws.ec2.model.DescribeFleetsInstances]] =
      None,
    context: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.FleetData = {
    import FleetData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetData
      .builder()
      .optionallyWith(activityStatus.map(value => value.unwrap))(
        _.activityStatus
      )
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(fleetState.map(value => value.unwrap))(_.fleetState)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        excessCapacityTerminationPolicy.map(value => value.unwrap)
      )(_.excessCapacityTerminationPolicy)
      .optionallyWith(fulfilledCapacity.map(value => value: java.lang.Double))(
        _.fulfilledCapacity
      )
      .optionallyWith(
        fulfilledOnDemandCapacity.map(value => value: java.lang.Double)
      )(_.fulfilledOnDemandCapacity)
      .optionallyWith(
        launchTemplateConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchTemplateConfigs)
      .optionallyWith(
        targetCapacitySpecification.map(value => value.buildAwsValue())
      )(_.targetCapacitySpecification)
      .optionallyWith(
        terminateInstancesWithExpiration.map(value => value: java.lang.Boolean)
      )(_.terminateInstancesWithExpiration)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(validFrom.map(value => DateTime.unwrap(value): Instant))(
        _.validFrom
      )
      .optionallyWith(validUntil.map(value => DateTime.unwrap(value): Instant))(
        _.validUntil
      )
      .optionallyWith(
        replaceUnhealthyInstances.map(value => value: java.lang.Boolean)
      )(_.replaceUnhealthyInstances)
      .optionallyWith(spotOptions.map(value => value.buildAwsValue()))(
        _.spotOptions
      )
      .optionallyWith(onDemandOptions.map(value => value.buildAwsValue()))(
        _.onDemandOptions
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(context.map(value => value: java.lang.String))(_.context)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FleetData.ReadOnly =
    zio.aws.ec2.model.FleetData.wrap(buildAwsValue())
}
object FleetData {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.FleetData] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetData = zio.aws.ec2.model.FleetData(
      activityStatus.map(value => value),
      createTime.map(value => value),
      fleetId.map(value => value),
      fleetState.map(value => value),
      clientToken.map(value => value),
      excessCapacityTerminationPolicy.map(value => value),
      fulfilledCapacity.map(value => value),
      fulfilledOnDemandCapacity.map(value => value),
      launchTemplateConfigs.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      targetCapacitySpecification.map(value => value.asEditable),
      terminateInstancesWithExpiration.map(value => value),
      `type`.map(value => value),
      validFrom.map(value => value),
      validUntil.map(value => value),
      replaceUnhealthyInstances.map(value => value),
      spotOptions.map(value => value.asEditable),
      onDemandOptions.map(value => value.asEditable),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      errors.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      instances.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      context.map(value => value)
    )
    def activityStatus: Option[zio.aws.ec2.model.FleetActivityStatus]
    def createTime: Option[DateTime]
    def fleetId: Option[FleetId]
    def fleetState: Option[zio.aws.ec2.model.FleetStateCode]
    def clientToken: Option[String]
    def excessCapacityTerminationPolicy
        : Option[zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy]
    def fulfilledCapacity: Option[Double]
    def fulfilledOnDemandCapacity: Option[Double]
    def launchTemplateConfigs
        : Option[List[zio.aws.ec2.model.FleetLaunchTemplateConfig.ReadOnly]]
    def targetCapacitySpecification
        : Option[zio.aws.ec2.model.TargetCapacitySpecification.ReadOnly]
    def terminateInstancesWithExpiration: Option[Boolean]
    def `type`: Option[zio.aws.ec2.model.FleetType]
    def validFrom: Option[DateTime]
    def validUntil: Option[DateTime]
    def replaceUnhealthyInstances: Option[Boolean]
    def spotOptions: Option[zio.aws.ec2.model.SpotOptions.ReadOnly]
    def onDemandOptions: Option[zio.aws.ec2.model.OnDemandOptions.ReadOnly]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def errors: Option[List[zio.aws.ec2.model.DescribeFleetError.ReadOnly]]
    def instances
        : Option[List[zio.aws.ec2.model.DescribeFleetsInstances.ReadOnly]]
    def context: Option[String]
    def getActivityStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.FleetActivityStatus] =
      AwsError.unwrapOptionField("activityStatus", activityStatus)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetState: ZIO[Any, AwsError, zio.aws.ec2.model.FleetStateCode] =
      AwsError.unwrapOptionField("fleetState", fleetState)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getExcessCapacityTerminationPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy
    ] = AwsError.unwrapOptionField(
      "excessCapacityTerminationPolicy",
      excessCapacityTerminationPolicy
    )
    def getFulfilledCapacity: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fulfilledCapacity", fulfilledCapacity)
    def getFulfilledOnDemandCapacity: ZIO[Any, AwsError, Double] = AwsError
      .unwrapOptionField("fulfilledOnDemandCapacity", fulfilledOnDemandCapacity)
    def getLaunchTemplateConfigs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.FleetLaunchTemplateConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("launchTemplateConfigs", launchTemplateConfigs)
    def getTargetCapacitySpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TargetCapacitySpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetCapacitySpecification",
      targetCapacitySpecification
    )
    def getTerminateInstancesWithExpiration: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "terminateInstancesWithExpiration",
        terminateInstancesWithExpiration
      )
    def getType: ZIO[Any, AwsError, zio.aws.ec2.model.FleetType] =
      AwsError.unwrapOptionField("type", `type`)
    def getValidFrom: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validFrom", validFrom)
    def getValidUntil: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("validUntil", validUntil)
    def getReplaceUnhealthyInstances: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("replaceUnhealthyInstances", replaceUnhealthyInstances)
    def getSpotOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotOptions.ReadOnly] =
      AwsError.unwrapOptionField("spotOptions", spotOptions)
    def getOnDemandOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.OnDemandOptions.ReadOnly] =
      AwsError.unwrapOptionField("onDemandOptions", onDemandOptions)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DescribeFleetError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DescribeFleetsInstances.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getContext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("context", context)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetData
  ) extends zio.aws.ec2.model.FleetData.ReadOnly {
    override val activityStatus: Option[zio.aws.ec2.model.FleetActivityStatus] =
      scala
        .Option(impl.activityStatus())
        .map(value => zio.aws.ec2.model.FleetActivityStatus.wrap(value))
    override val createTime: Option[DateTime] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val fleetId: Option[FleetId] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.ec2.model.primitives.FleetId(value))
    override val fleetState: Option[zio.aws.ec2.model.FleetStateCode] = scala
      .Option(impl.fleetState())
      .map(value => zio.aws.ec2.model.FleetStateCode.wrap(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val excessCapacityTerminationPolicy
        : Option[zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy] = scala
      .Option(impl.excessCapacityTerminationPolicy())
      .map(value =>
        zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy.wrap(value)
      )
    override val fulfilledCapacity: Option[Double] =
      scala.Option(impl.fulfilledCapacity()).map(value => value: Double)
    override val fulfilledOnDemandCapacity: Option[Double] =
      scala.Option(impl.fulfilledOnDemandCapacity()).map(value => value: Double)
    override val launchTemplateConfigs
        : Option[List[zio.aws.ec2.model.FleetLaunchTemplateConfig.ReadOnly]] =
      scala
        .Option(impl.launchTemplateConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.FleetLaunchTemplateConfig.wrap(item)
          }.toList
        )
    override val targetCapacitySpecification
        : Option[zio.aws.ec2.model.TargetCapacitySpecification.ReadOnly] = scala
      .Option(impl.targetCapacitySpecification())
      .map(value => zio.aws.ec2.model.TargetCapacitySpecification.wrap(value))
    override val terminateInstancesWithExpiration: Option[Boolean] = scala
      .Option(impl.terminateInstancesWithExpiration())
      .map(value => value: Boolean)
    override val `type`: Option[zio.aws.ec2.model.FleetType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ec2.model.FleetType.wrap(value))
    override val validFrom: Option[DateTime] = scala
      .Option(impl.validFrom())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val validUntil: Option[DateTime] = scala
      .Option(impl.validUntil())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val replaceUnhealthyInstances: Option[Boolean] = scala
      .Option(impl.replaceUnhealthyInstances())
      .map(value => value: Boolean)
    override val spotOptions: Option[zio.aws.ec2.model.SpotOptions.ReadOnly] =
      scala
        .Option(impl.spotOptions())
        .map(value => zio.aws.ec2.model.SpotOptions.wrap(value))
    override val onDemandOptions
        : Option[zio.aws.ec2.model.OnDemandOptions.ReadOnly] = scala
      .Option(impl.onDemandOptions())
      .map(value => zio.aws.ec2.model.OnDemandOptions.wrap(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val errors
        : Option[List[zio.aws.ec2.model.DescribeFleetError.ReadOnly]] = scala
      .Option(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.DescribeFleetError.wrap(item)
        }.toList
      )
    override val instances
        : Option[List[zio.aws.ec2.model.DescribeFleetsInstances.ReadOnly]] =
      scala
        .Option(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.DescribeFleetsInstances.wrap(item)
          }.toList
        )
    override val context: Option[String] =
      scala.Option(impl.context()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetData
  ): zio.aws.ec2.model.FleetData.ReadOnly = new Wrapper(impl)
}
