package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Filter(
    name: Option[String] = None,
    values: Option[Iterable[String]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Filter
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Filter.ReadOnly =
    zio.aws.ec2.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Filter = zio.aws.ec2.model
      .Filter(name.map(value => value), values.map(value => value))
    def name: Option[String]
    def values: Option[List[String]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Filter
  ) extends zio.aws.ec2.model.Filter.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val values: Option[List[String]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Filter
  ): zio.aws.ec2.model.Filter.ReadOnly = new Wrapper(impl)
}
