package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExportImageRequest(
    clientToken: Option[String] = None,
    description: Option[String] = None,
    diskImageFormat: zio.aws.ec2.model.DiskImageFormat,
    imageId: ImageId,
    s3ExportLocation: zio.aws.ec2.model.ExportTaskS3LocationRequest,
    roleName: Option[String] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ExportImageRequest = {
    import ExportImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportImageRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .diskImageFormat(diskImageFormat.unwrap)
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .s3ExportLocation(s3ExportLocation.buildAwsValue())
      .optionallyWith(roleName.map(value => value: java.lang.String))(
        _.roleName
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ExportImageRequest.ReadOnly =
    zio.aws.ec2.model.ExportImageRequest.wrap(buildAwsValue())
}
object ExportImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ExportImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ExportImageRequest =
      zio.aws.ec2.model.ExportImageRequest(
        clientToken.map(value => value),
        description.map(value => value),
        diskImageFormat,
        imageId,
        s3ExportLocation.asEditable,
        roleName.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientToken: Option[String]
    def description: Option[String]
    def diskImageFormat: zio.aws.ec2.model.DiskImageFormat
    def imageId: ImageId
    def s3ExportLocation: zio.aws.ec2.model.ExportTaskS3LocationRequest.ReadOnly
    def roleName: Option[String]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDiskImageFormat
        : ZIO[Any, Nothing, zio.aws.ec2.model.DiskImageFormat] =
      ZIO.succeed(diskImageFormat)
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
    def getS3ExportLocation: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.ExportTaskS3LocationRequest.ReadOnly
    ] = ZIO.succeed(s3ExportLocation)
    def getRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportImageRequest
  ) extends zio.aws.ec2.model.ExportImageRequest.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val diskImageFormat: zio.aws.ec2.model.DiskImageFormat =
      zio.aws.ec2.model.DiskImageFormat.wrap(impl.diskImageFormat())
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
    override val s3ExportLocation
        : zio.aws.ec2.model.ExportTaskS3LocationRequest.ReadOnly =
      zio.aws.ec2.model.ExportTaskS3LocationRequest
        .wrap(impl.s3ExportLocation())
    override val roleName: Option[String] =
      scala.Option(impl.roleName()).map(value => value: String)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportImageRequest
  ): zio.aws.ec2.model.ExportImageRequest.ReadOnly = new Wrapper(impl)
}
